/*
 * Created by ALL-INKL.COM - Neue Medien Muennich - 04. Feb 2014
 * Licensed under the terms of GPL, LGPL and MPL licenses.
 */
CKEDITOR.dialog.add("base64imageDialog", function(editor){
	
	var t = null,
		imgPreview = null, fileI = null;
	
	/* Check File Reader Support */
	function fileSupport() {
		var r = false, n = null;
		try {
			if(FileReader) {
				var n = document.createElement("input");
				if(n && "files" in n) r = true;
			}
		} catch(e) { r = false; }
		n = null;
		return r;
	}
	var fsupport = fileSupport();
	
	/* Load preview image */
	function imagePreviewLoad(s) {
		
		/* no preview */
		if(typeof(s) != "string" || !s) {
			imgPreview.getElement().setHtml("");
			return;
		}
		
		/* Create image */
		var i = new Image();
		
		/* Display loading text in preview element */
		imgPreview.getElement().setHtml("Loading...");
		
		/* When image is loaded */
		i.onload = function() {
			
			/* Remove preview */
			imgPreview.getElement().setHtml("");
			
			this.id = editor.id+"previewimage";
			this.setAttribute("style", "max-width:400px;max-height:200px;");
			this.setAttribute("alt", "");
			
			/* Insert preview image */
			try {
				var p = imgPreview.getElement().$;
				if(p) p.appendChild(this);
			} catch(e) {}
			
		};
		
		/* Error Function */
		i.onerror = function(){ imgPreview.getElement().setHtml(""); };
		i.onabort = function(){ imgPreview.getElement().setHtml(""); };
		
		/* Load image */
		i.src = s;
	}
	
	/* Change input values and preview image */
	function imagePreview(src){
		
		/* Remove preview */
		imgPreview.getElement().setHtml("");
		
		if(fsupport) {
			
			/* Read file and load preview */
			var n = null;
			try { n = fileI.getInputElement().$; } catch(e) { n = null; }
			if(n && "files" in n && n.files && n.files.length > 0 && n.files[0]) {
				if("type" in n.files[0] && !n.files[0].type.match("image.*")) return;
				if(!FileReader) return;
				imgPreview.getElement().setHtml("Loading...");
				var fr = new FileReader();
				fr.onload = (function(f) { return function(e) {
					imgPreview.getElement().setHtml("");
					imagePreviewLoad(e.target.result);
				}; })(n.files[0]);
				fr.onerror = function(){ imgPreview.getElement().setHtml(""); };
				fr.onabort = function(){ imgPreview.getElement().setHtml(""); };
				fr.readAsDataURL(n.files[0]);
			}
		}
	};
	
	if(fsupport) {
		
		/* Dialog with file and url image source */
		var sourceElements = [			
			{
				type: "hbox",
				widths: ["70px"],
				children: [
					{
						type: "file",
						id: "file",
						label: "",
						onChange: function(){ imagePreview("file"); }
					}
				]
			},
			{
				type: "html",
				id: "preview",
				html: new CKEDITOR.template("<div style=\"text-align:center;\"></div>").output()
			}
		];
		
	}
	
	/* Dialog */
    return {
		title: "Upload image",
        minWidth: 450,
        minHeight: 180,
		onLoad: function () {
			t = this;
			/* Get image preview element */
			imgPreview = this.getContentElement("tab-source", "preview");
			fileI = this.getContentElement("tab-source", "file");
		},
		onShow: function(){			
			/* Remove preview */
			imgPreview.getElement().setHtml("");			
		},
		onOk : function(){
			
			/* Get image source */
			var src = "";
			try { src = CKEDITOR.document.getById(editor.id+"previewimage").$.src; } catch(e) { src = ""; }
			if(typeof(src) != "string" || src == null || src === "") return;
			
			var newImg = editor.document.createElement("img");
			newImg.setAttribute("src", src);
			src = null;
			
			editor.insertElement(newImg);			
		},
		
		/* Dialog form */
        contents: [
            {
                id: "tab-source",
                label: editor.lang.common.generalTab,
                elements: sourceElements
            }
        ]
    };
});
